/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.swt.internal.flex;

import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class TableItemRendererClassFactory implements intrinsic.mx.core.IFactory {
/*+
 public function newInstance():*  
{
	return internalNewInstance__();
} 
 +*/
	Table table;
	TableColumn column;
	boolean headerRenderer;
	

public TableItemRendererClassFactory(Table parent, TableColumn column, boolean headerRenderer) {
	this.table = parent;
	this.column = column;
	this.headerRenderer = headerRenderer;
}

public Object internalNewInstance() {
	return new TableItemRenderer(table, column, headerRenderer);
}


}